/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class EntityTypeTagCondition
implements Condition<EntityType<?>> {
    private final HolderSet.Named<EntityType<?>> entries;

    private EntityTypeTagCondition(HolderSet.Named<EntityType<?>> entries) {
        this.entries = entries;
    }

    public static ConditionFactory<EntityType<?>> factory() {
        return ConditionFactory.withData(EntityTypeTagCondition::parse);
    }

    public static Result<EntityTypeTagCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(EntityTypeTagCondition::parse);
    }

    public static Result<EntityTypeTagCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTag = rootObject.get("tag").andThen(JsonParseUtils::parseEntityTypeTag).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new EntityTypeTagCondition((HolderSet.Named)optTag.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(EntityType<?> entityType) {
        return Registry.f_122826_.m_7854_(entityType).map((? super T key) -> this.entries.m_203333_(Registry.f_122826_.m_206081_(key))).orElse(false);
    }
}

